{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Tel.: +0351-8012255                   =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 04.03.98 - 00:22:13 $                                        =}
{========================================================================}
unit Unit2;

interface

uses
    Windows,
    SysUtils,
    Classes,
    Graphics,
    Forms,
    Controls,
    StdCtrls,
    Buttons,
    ComCtrls,
    ExtCtrls,
    Dialogs,
    MMPCX;

type
  TFormatDlg = class(TForm)
    editFile: TEdit;
    Label1: TLabel;
    Button1: TButton;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    comboMode: TComboBox;
    comboFreq: TComboBox;
    comboFormat: TComboBox;
    comboCompression: TComboBox;
    comboLayer: TComboBox;
    comboBitrates: TComboBox;
    btnCancel: TButton;
    btnOK: TButton;
    SaveDialog: TSaveDialog;
    procedure FormShow(Sender: TObject);
    procedure comboLayerChange(Sender: TObject);
    procedure editFileChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    function  GetFileName: TFileName;
  public
    procedure SetupBitRates;

    property FileName: TFileName read GetFileName;
  end;

var
  FormatDlg: TFormatDlg;

implementation

uses Unit1;

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TFormatDlg.FormShow(Sender: TObject);
var
   idx: integer;
begin
   with MainForm.RecStream.Format do
   begin
      comboMode.ItemIndex := Ord(Mode);
      case Frequency of
          11025: comboFreq.ItemIndex := 0;
          16000: comboFreq.ItemIndex := 1;
          22025: comboFreq.ItemIndex := 2;
          24000: comboFreq.ItemIndex := 3;
          32000: comboFreq.ItemIndex := 4;
          44100: comboFreq.ItemIndex := 5;
          48000: comboFreq.ItemIndex := 6;
      end;

      comboFormat.ItemIndex := Ord(FileFormat);

      case Compression of
         cMPEG: comboCompression.ItemIndex := 0;
         else   comboCompression.ItemIndex := 1;
      end;

      comboLayer.ItemIndex := Ord(MPEGLayer);

      SetupBitRates;

      idx := comboBitRates.Items.IndexOf(IntToStr(MPEGBitRate));
      if (idx >= 0) then
         comboBitRates.ItemIndex := idx;

      btnOK.Enabled := (editFile.Text <> '');
   end;
end;

{------------------------------------------------------------------------------}
procedure TFormatDlg.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if (ModalResult = mrOK) then
   with MainForm.RecStream.Format do
   begin
      Mode := TMMPCXFMTMode(comboMode.ItemIndex);

      case comboFreq.ItemIndex of
          0 : Frequency := 11025;
          1 : Frequency := 16000;
          2 : Frequency := 22025;
          3 : Frequency := 24000;
          4 : Frequency := 32000;
          5 : Frequency := 44100;
          6 : Frequency := 48000;
      end;

      FileFormat := TMMPCXFileFormat(comboFormat.ItemIndex);

      case comboCompression.ItemIndex of
          0: Compression := cMpeg;
          else Compression := cPCM16;
      end;

      MPEGLayer := TMMPCXMPEGLayer(comboLayer.ItemIndex);
      MPEGBitRate := StrToIntDef(comboBitRates.Items[comboBitRates.ItemIndex],128);
   end;
end;

{------------------------------------------------------------------------------}
procedure TFormatDlg.SetupBitRates;
begin
   with comboBitRates do
   begin
      comboBitRates.Clear;
      if (comboLayer.ItemIndex = 0) then
      begin
         Items.Add('32');
         Items.Add('64');
         Items.Add('96');
         Items.Add('128');
         Items.Add('160');
         Items.Add('192');
         Items.Add('224');
         Items.Add('256');
         Items.Add('288');
         Items.Add('320');
         Items.Add('352');
         Items.Add('384');
         Items.Add('416');
         Items.Add('448');
      end
      else
      begin
         Items.Add('64');
         Items.Add('96');
         Items.Add('112');
         Items.Add('128');
         Items.Add('160');
         Items.Add('192');
         Items.Add('224');
         Items.Add('256');
         Items.Add('320');
         Items.Add('384');
      end;
      ItemIndex := 3;
   end;
end;

{------------------------------------------------------------------------------}
procedure TFormatDlg.comboLayerChange(Sender: TObject);
begin
   SetupBitRates;
end;

{------------------------------------------------------------------------------}
procedure TFormatDlg.editFileChange(Sender: TObject);
begin
   btnOK.Enabled := (editFile.Text <> '');
end;

{------------------------------------------------------------------------------}
procedure TFormatDlg.Button1Click(Sender: TObject);
begin
   if SaveDialog.Execute then
   begin
      editFile.Text := SaveDialog.FileName;
   end;
end;

{------------------------------------------------------------------------------}
function TFormatDlg.GetFileName: TFileName;
begin
   Result := editFile.Text;
end;

end.

